// stack.java
// demonstruje dziaanie stosu
// uruchomienie programu: C>java StackApp
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;        // rozmiar tablicy zawierajcej stos
   private long[] stackArray;  // tablica zawierajca stos
   private int top;            // indeks szczytu stosu
//--------------------------------------------------------------
   public StackX(int s)         // konstruktor
      {
      maxSize = s;             // ustawiamy rozmiar tablicy
      stackArray = new long[maxSize];  // tworzymy tablic
      top = -1;                // na razie brak elementw
      }
//--------------------------------------------------------------
   public void push(long j)    // odkada element na szczyt stosu
      {
      stackArray[++top] = j;     // zwikszamy top, odkadamy element
      }
//--------------------------------------------------------------
   public long pop()           // pobiera element ze szczytu stosu
      {
      return stackArray[top--];  // pobieramy element, zmniejszamy top
      }
//--------------------------------------------------------------
   public long peek()          // podglda warto na szczycie stosu
      {
      return stackArray[top];
      }
//--------------------------------------------------------------
   public boolean isEmpty()    // zwraca true, jeeli stos pusty
      {
      return (top == -1);
      }
//--------------------------------------------------------------
   public boolean isFull()     // zwraca true, jeeli stos peny
      {
      return (top == maxSize-1);
      }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class StackApp
   {
   public static void main(String[] args)
      {
      StackX theStack = new StackX(10);  // tworzymy nowy stos
      theStack.push(20);               // odkadamy elementy na stosie
      theStack.push(40);
      theStack.push(60);
      theStack.push(80);

      while( !theStack.isEmpty() )     // dopki stos nie jest pusty...
         {                             // ...pobieramy z niego elementy
         long value = theStack.pop();
         System.out.print(value);      // wypisanie elementu
         System.out.print(" ");
         }  // koniec while
      System.out.println("");
      }  // koniec main()
   }  // koniec klasy StackApp
////////////////////////////////////////////////////////////////
